from app.entities import models
from rest_framework import serializers
from django.db.models import Q
from django.conf import settings
from app.applicationlayer.utils import model_to_dict
from drf_writable_nested import WritableNestedModelSerializer
from app.applicationlayer.cms.utils_cr import (get_account_details,
                                               get_dept_details,
                                               get_companies_details)


from app.applicationlayer.cms.template.approver.serializers import ChangeRequestTemplateApproversSerializer
from app.applicationlayer.cms.template.stakeholder.serializers import ChangeRequestTemplateStakeHoldersSerializer
from app.applicationlayer.cms.template.attachment.serializers import ChangeRequestTemplateAttachmentsSerializer
from app.applicationlayer.cms.template.details.serializers import ChangeRequestTemplateDetailsSerializer

from django.conf import settings

from rest_framework.exceptions import ValidationError
from app.applicationlayer.cms.utils_cr import (
    BadRequestException
)


class ChangeRequestTemplatesSerializer(
    serializers.ModelSerializer
):
    tmp_approvers = ChangeRequestTemplateApproversSerializer(
        many=True, read_only=True)
    tmp_stakes = ChangeRequestTemplateStakeHoldersSerializer(
        many=True, read_only=True)
    tmp_attachments = ChangeRequestTemplateAttachmentsSerializer(
        many=True, read_only=True)
    tmp_details = ChangeRequestTemplateDetailsSerializer(
        many=True, read_only=True)

    def to_representation(self, instance):
        ret = super().to_representation(instance)
        try:
            requested_to_user_object = {
                "id": instance.requested_to_user.id,
                "name": instance.requested_to_user.name,
                "username": instance.requested_to_user.username,
                "code": instance.requested_to_user.code,
                "email": instance.requested_to_user.email,
                "contact_no": instance.requested_to_user.contact_no
            }

            ret['requested_to_company'] = model_to_dict(instance.requested_to_company)
            ret['requested_to_department'] = model_to_dict(instance.requested_to_department)
            ret['requested_to_user'] = requested_to_user_object

            ret['company'] = instance.requested_to_company.name
            ret['department'] = instance.requested_to_department.name
            ret['point_of_contact'] = instance.requested_to_user.name
            ret['created_by'] = instance.created_by_user.name

            return ret

        except Exception as e:
            
            ret['requested_to_company'] = "none"
            ret['requested_to_department'] = "none"
            ret['requested_to_user'] = "none"

            ret['company'] = "none"
            ret['department'] = "none"
            ret['point_of_contact'] = "none"
            ret['created_by'] = "none"

            return ret
    
    class Meta:
        model = models.ChangeRequestTemplateHeader
        # fields = '__all__'
        fields = ('template_no', 'requested_to_template_name',
                  'requested_to_objective', 'requested_to_target_date',
                  'requested_to_priority', 'description', 'created',
                  'requested_to_template_id', 'requested_to_company',
                  'requested_to_department', 'requested_to_user',
                  'created_by_user', 'created_by_department',
                  'tmp_approvers', 'tmp_stakes', 'tmp_attachments',
                  'tmp_details')

        read_only_fields = ['created', 'template_no']
        # extra_kwargs = {
        #      "requested_to_template_id": {
        #             "error_messages": {
        #                 "unique": "ssCR prefix should be unique"
        #                 }
        #             }
        #         }

    # def is_valid(self, raise_exception=False):

    #     assert not hasattr(self, 'restore_object'), (
    #         'Serializer `%s.%s` has old-style version 2 `.restore_object()` '
    #         'that is no longer compatible with REST framework 3. '
    #         'Use the new-style `.create()` and `.update()` methods instead.' %
    #         (self.__class__.__module__, self.__class__.__name__)
    #     )

    #     assert hasattr(self, 'initial_data'), (
    #         'Cannot call `.is_valid()` as no `data=` keyword argument was '
    #         'passed when instantiating the serializer instance.'
    #     )

    #     if not hasattr(self, '_validated_data'):
    #         try:
    #             self._validated_data = self.run_validation(self.initial_data)
    #         except ValidationError as exc:
    #             self._validated_data = {}
    #             self._errors = exc.detail
    #         else:
    #             self._errors = {}

    #     # if validation failed
    #     if self._errors and raise_exception:
    #         error_message = {}
    #         message = str(self.errors)

    #         for k, v in self.errors.items():
    #             message = str(v)
    #             start = message.find('string=') + 8
    #             end = message.find(', code=') - 1
    #             message = message[start:end]

    #             error_message[str(k)] = message

    #         raise BadRequestException(error_message)

    #     return not bool(self._errors)


class ChangeRequestTemplatesSerializerList(
    serializers.ModelSerializer
):

    def to_representation(self, instance):
        ret = super().to_representation(instance)
        try:
            ret['company'] = instance.requested_to_company.name
            ret['department'] = instance.requested_to_department.name
            ret['point_of_contact'] = instance.requested_to_user.name
            ret['created_by'] = instance.created_by_user.name
            child = models.ChangeRequestFormHeader.objects.filter(
                template_no=instance.template_no
            )


            can_delete = ''

            if child.count() > 0:

                can_delete = False

            else:

                can_delete = True

            ret['can_delete'] = can_delete

            return ret
        except Exception as e:
            ret['company'] = "none"
            ret['department'] = "none"
            ret['point_of_contact'] = "none"
            ret['created_by'] = "none"
            
            return ret

    class Meta:
        model = models.ChangeRequestTemplateHeader
        fields = '__all__'
        read_only_fields = ['created', 'template_no']