from .base import *
import configparser

DEBUG = True

ALLOWED_HOSTS = ['*']

config = configparser.ConfigParser()
config_file = os.path.join('./', 'env.ini')
config.read(config_file)

DATABASES = {
    'default': {
        'ENGINE': config['UAT']['DATABASE_ENGINE'],
        'NAME': config['UAT']['DATABASE_NAME'],
        'USER': config['UAT']['DATABASE_USER'],
        'PASSWORD': config['UAT']['DATABASE_PASSWORD'],
        'HOST': config['UAT']['DATABASE_HOST'],
        'PORT': config['UAT']['DATABASE_PORT'],
    }
}

# ****************
# PROGRAM SETTINGS
# ****************
SESSION_TIMEOUT = config['UAT']['SESSION_TIMEOUT']
FRONT_END_URL = config['UAT']['FRONT_END_URL']
AUTH_ACCESSS_TOKEN_TIMEOUT = config['UAT']['AUTH_ACCESSS_TOKEN_TIMEOUT']
USER_DEFAULT_PASSWORD = config['UAT']['USER_DEFAULT_PASSWORD']
REALTIMESERVER_IP = config['NOTIFICATION']['REALTIMESERVER_IP']


# Notification Messages
APPROVER_MESSAGE = config['NOTIFICATION_EMAIL']['APPROVER_MESSAGE']
REQUESTOR_MESSAGE = config['NOTIFICATION_EMAIL']['REQUESTOR_MESSAGE']
REQUESTOR_REJECT_MESSAGE = config['NOTIFICATION_EMAIL']['REQUESTOR_REJECT_MESSAGE']
VENDOR_ACKNOWLEDGE_MESSAGE = config['NOTIFICATION_EMAIL']['VENDOR_ACKNOWLEDGE_MESSAGE']
REQUESTOR_ACKNOWLEDGE_MESSAGE = config['NOTIFICATION_EMAIL']['REQUESTOR_ACKNOWLEDGE_MESSAGE']
REQUESTOR_COMPLETION_MESSAGE = config['NOTIFICATION_EMAIL']['REQUESTOR_COMPLETION_MESSAGE']
VENDOR_ACCEPTANCE_MESSAGE = config['NOTIFICATION_EMAIL']['VENDOR_ACCEPTANCE_MESSAGE']
VENDOR_REJECT_MESSAGE = config['NOTIFICATION_EMAIL']['VENDOR_REJECT_MESSAGE']

#ADMIN PROFILE
CATCH_EMAIL = config['UAT']['CATCH_EMAIL']
