from .base import *
import configparser

DEBUG = False

ALLOWED_HOSTS = ['*']

config = configparser.ConfigParser()
config_file = os.path.join('./', 'env.ini')
config.read(config_file)

DATABASES = {
    'default': {
        'ENGINE': config['PRODUCTION']['DATABASE_ENGINE'],
        'NAME': config['PRODUCTION']['DATABASE_NAME'],
        'USER': config['PRODUCTION']['DATABASE_USER'],
        'PASSWORD': config['PRODUCTION']['DATABASE_PASSWORD'],
        'HOST': config['PRODUCTION']['DATABASE_HOST'],
        'PORT': config['PRODUCTION']['DATABASE_PORT'],
    }
}

# ****************
# PROGRAM SETTINGS
# ****************
SESSION_TIMEOUT = config['PRODUCTION']['SESSION_TIMEOUT']
FRONT_END_URL = config['PRODUCTION']['FRONT_END_URL']
AUTH_ACCESSS_TOKEN_TIMEOUT = config['PRODUCTION']['AUTH_ACCESSS_TOKEN_TIMEOUT']
USER_DEFAULT_PASSWORD = config['PRODUCTION']['USER_DEFAULT_PASSWORD']
REALTIMESERVER_IP = config['NOTIFICATION']['REALTIMESERVER_IP']

# Notification Messages
APPROVER_MESSAGE = config['NOTIFICATION_EMAIL']['APPROVER_MESSAGE']
REQUESTOR_MESSAGE = config['NOTIFICATION_EMAIL']['REQUESTOR_MESSAGE']
REQUESTOR_REJECT_MESSAGE = config['NOTIFICATION_EMAIL']['REQUESTOR_REJECT_MESSAGE']
VENDOR_ACKNOWLEDGE_MESSAGE = config['NOTIFICATION_EMAIL']['VENDOR_ACKNOWLEDGE_MESSAGE']
REQUESTOR_ACKNOWLEDGE_MESSAGE = config['NOTIFICATION_EMAIL']['REQUESTOR_ACKNOWLEDGE_MESSAGE']
REQUESTOR_COMPLETION_MESSAGE = config['NOTIFICATION_EMAIL']['REQUESTOR_COMPLETION_MESSAGE']
VENDOR_ACCEPTANCE_MESSAGE = config['NOTIFICATION_EMAIL']['VENDOR_ACCEPTANCE_MESSAGE']
VENDOR_REJECT_MESSAGE = config['NOTIFICATION_EMAIL']['VENDOR_REJECT_MESSAGE']

#ADMIN PROFILE
CATCH_EMAIL = config['PRODUCTION']['CATCH_EMAIL']
