from .base import *
import configparser

DEBUG = True

ALLOWED_HOSTS = ['*']

INSTALLED_APPS += [
    'rest_framework_swagger',
]

REST_FRAMEWORK = {
    'EXCEPTION_HANDLER': 'rest_framework.views.exception_handler',
    'UNAUTHENTICATED_USER': None,
}

config = configparser.ConfigParser()
config.read('env.ini')

DATABASES = {
    'default': {
        'ENGINE': config['UAT']['DATABASE_ENGINE'],
        'NAME': config['UAT']['DATABASE_NAME'],
        'USER': config['UAT']['DATABASE_USER'],
        'PASSWORD': config['UAT']['DATABASE_PASSWORD'],
        'HOST': config['UAT']['DATABASE_HOST'],
        'PORT': config['UAT']['DATABASE_PORT'],
    }
}


AUTHENTICATOR_IP = config['SERVICE']['AUTHENTICATOR_IP']
AUTHENTICATOR_PATH = '/api/v1/authenticator'

VALIDATE_TOKEN_URL = f'http://{AUTHENTICATOR_IP}{AUTHENTICATOR_PATH}/validate-token/'
ACCOUNT_GROUP = f'http://{AUTHENTICATOR_IP}{AUTHENTICATOR_PATH}/application-dependent'
