from rest_framework import viewsets, status
from rest_framework.response import Response
from app.applicationlayer.utils import model_to_dict
from rest_framework.filters import SearchFilter, OrderingFilter
from django_filters import rest_framework as filters
from app.entities.models import Department, Delegation
from app.applicationlayer.utils import (
    CustomPagination, status_message_response
)

from django_filters.rest_framework import DjangoFilterBackend
from app.applicationlayer.master.department.serializer import (
    AdminDepartmentSerializer,
    DelegationSerializer)
from app.applicationlayer.management.department.table_filters import DepartmentFilterSet
from app.helper.decorators import rms
from rest_framework.decorators import action


class AdminDepartmentViewSet(viewsets.ModelViewSet):
    queryset = Department.objects.all().order_by('-created')
    serializer_class = AdminDepartmentSerializer
    pagination_class = CustomPagination
    lookup_field = 'code'
    filter_backends = (DjangoFilterBackend, SearchFilter, OrderingFilter)
    filterset_class = DepartmentFilterSet
    ordering_fields = '__all__'
    search_fields = ('name', 'company__name', 'code')

    # @rms.department_list
    def list(self, request, *args, **kwargs):
        try:
            company = self.request.query_params['company_code']
            queryset = self.filter_queryset(self.get_queryset())
            queryset = queryset.filter(company__code=company)
            queryset = queryset.exclude(id=1)
            page = self.paginate_queryset(queryset)

            if page is not None:
                serializer = self.get_serializer(page, many=True)

                message = status_message_response(
                    200,
                    'success',
                    'list of Department found',
                    serializer.data
                )
                return self.get_paginated_response(message)
        except Exception as e:
            message = status_message_response(
                400,
                'failed',
                'company_code is required',
                ''
            )
            return Response(message)

    @action(detail=True,
            methods=['get'],
            url_path='delegations',
            name="Delegation Filtered List")
    def delegations(self, request, *args, **kwargs):

        try:
            dept_code = kwargs['code']
            queryset = Delegation.objects.filter(departments__code=dept_code)
            page = self.paginate_queryset(queryset)
                
            if page is not None:
                self.serializer_class = DelegationSerializer
                serializer = self.get_serializer(page, many=True)

                message = status_message_response(
                    200,
                    'success',
                    'list of filtered delegations found',
                    serializer.data
                )
                return self.get_paginated_response(message)
        except Exception as e:
            message = status_message_response(
                400,
                'failed',
                str(e),
                ''
            )
            return Response(message)