from app.entities import models
from rest_framework import serializers
from django.db.models import Q


class headers(serializers.ModelSerializer):

    def to_representation(self, instance):
        ret = super().to_representation(instance)
        ret['modified'] = instance.modified.strftime('%Y-%m-%d-%H:%M:%S')

        return ret


    class Meta:
        model = models.Company
        fields = (
            'name',
            'contact_details'
        )
