from app.entities import models
from rest_framework import serializers
from app.applicationlayer.utils import model_to_dict


class ChangeRequestFormApproversSerializer(
    serializers.ModelSerializer
):
    def to_representation(self, instance):
        ret = super().to_representation(instance)
        try:
            ret['company'] = model_to_dict(instance.user.department.company)
            ret['department'] = model_to_dict(instance.user.department)
            user_object = {
                "id": instance.user.id,
                "name": instance.user.name,
                "username": instance.user.username,
                "code": instance.user.code,
                "email": instance.user.email,
                "contact_no": instance.user.contact_no
            }
            ret['user'] = user_object
            
            if instance.form_code.status == 'Draft':
                if instance.tmp_approver:
                    if instance.tmp_approver.user or instance.tmp_approver.delegation.lower() == 'requestor':
                        ret['editable_user'] = False
                    else:
                        ret['editable_user'] = True

                    if instance.tmp_approver.company or instance.tmp_approver.delegation.lower() == 'requestor':
                        ret['editable_comp'] = False
                    else:
                        ret['editable_comp'] = True

                    if instance.tmp_approver.department  or instance.tmp_approver.delegation.lower() == 'requestor':
                        ret['editable_dept'] = False
                    else:
                        ret['editable_dept'] = True

                else:
                    ret['editable_user'] = True
                    ret['editable_comp'] = True
                    ret['editable_dept'] = True
            else:
                ret['editable_user'] = False
                ret['editable_comp'] = False
                ret['editable_dept'] = False

            return ret
        
        except Exception as e:
            
            if instance.form_code.status == 'Draft':
                if instance.tmp_approver:
                    if instance.tmp_approver.user or instance.tmp_approver.delegation.lower() == 'requestor':
                        ret['editable_user'] = False
                    else:
                        ret['user'] = None
                        ret['editable_user'] = True

                    if instance.tmp_approver.company or instance.tmp_approver.delegation.lower() == 'requestor':
                        ret['company'] = model_to_dict(
                            instance.tmp_approver.company)
                        ret['editable_comp'] = False
                    else:
                        ret['company'] = None
                        ret['editable_comp'] = True

                    if instance.tmp_approver.department  or instance.tmp_approver.delegation.lower() == 'requestor':
                        ret['department'] = model_to_dict(
                            instance.tmp_approver.department)
                        ret['editable_dept'] = False
                    else:
                        ret['department'] = None
                        ret['editable_dept'] = True

                else:
                    ret['editable_user'] = True
                    ret['editable_comp'] = True
                    ret['editable_dept'] = True
            else:
                ret['editable_user'] = False
                ret['editable_comp'] = False
                ret['editable_dept'] = False

            return ret

    class Meta:
        model = models.ChangeRequestFormApprovers
        fields = '__all__'
        read_only_fields = ['created', 'code']

