from rest_framework import serializers
from app.entities.models import ChangeRequestSettings
from app.applicationlayer.utils import model_to_dict


class ChangeRequestSettingsSerializer(serializers.ModelSerializer):

    def to_representation(self, instance):
        ret = super().to_representation(instance)

        if instance.behalf_user:

            behalf_user_object = {
                "id": instance.behalf_user.id,
                "name": instance.behalf_user.name,
                "username": instance.behalf_user.username,
                "code": instance.behalf_user.code,
                "email": instance.behalf_user.email,
                "contact_no": instance.behalf_user.contact_no
            }

            ret['behalf_user'] = behalf_user_object
            
        return ret

    class Meta:
        model = ChangeRequestSettings
        fields = '__all__'
        read_only_fields = ['created', 'code']

