#include "sd_simsDatabase.h"

int sd_getTime(int* day, int* month, int* year){
  time_t now;
  struct tm* local;
  
  time(&now);
  ctime(&now);
  local = localtime(&now);
  *day = local->tm_mday;
  *month = local->tm_mon+SD_DATE_MONTH_CORRECTION;
  *year = local->tm_year+SD_DATE_YEAR_CORRECTION;

  return SD_NO_VALUE;
}

int sd_checkDate(char* checkerBoard){
  int now_day, now_month, now_year;
  char check_day[SD_DATE], check_month[SD_DATE], check_year[SD_DATE_LONG];
  int sched_day, sched_month, sched_year;

  sd_getTime(&now_day,&now_month,&now_year);
  strncpy(check_year,checkerBoard,SD_DATE);
  strncpy(check_month,&checkerBoard[SD_DATE_MONTH_POSITION],SD_DATE_SHORT);
  strncpy(check_day,&checkerBoard[SD_DATE_LONG],SD_DATE_SHORT);

  sched_day = atoi(check_day);
  sched_month =  atoi(check_month);
  sched_year = atoi(check_year);
  
  if((now_day==sched_day) && (now_month==sched_month) && (now_year==sched_year))
    return SD_DAY_NOW;

  return SD_DAY_NOT_NOW;
}

int sd_compareGuest(char guest_id[]){
  MYSQL* conn;
  MYSQL_RES *res;
  MYSQL_ROW row;
  int blacklist = SD_GUEST_NOT_FOUND;
  char* server = SD_SERVER_ADDRESS;
  char* user = SD_USER;
  char* password = SD_PASSWORD;
  char* database = SD_DATABASE;
  char query[SD_MAX_CHARACTERS];
  unsigned int port = SD_PORT;
  
  conn = mysql_init(NULL);

  if (!mysql_real_connect(conn, server, user, password, database, port, NULL, SD_NO_VALUE)) {
    //fprintf(stderr, "Cred: %s\n", mysql_error(conn));
    return SD_DATABASE_ERROR;
  }

  sprintf(query,"SELECT date_of_visit, is_blacklisted FROM guests WHERE guest_id_number='%s'",guest_id);
  if(mysql_query(conn, query)) {
    //fprintf(stderr, "%s\n", mysql_error(conn));
    return SD_DATABASE_ERROR;
  }

  res = mysql_use_result(conn);
  while ((row = mysql_fetch_row(res)) != NULL){
  	if(!sd_checkDate(row[SD_GUESTS_DATE_OF_VISIT])){
        blacklist = atoi(row[SD_GUESTS_IS_BLACKLISTED]);
        if(!blacklist) break;
    }
  }
    
  mysql_free_result(res);
  mysql_close(conn);
  
  return blacklist;
}

